/* Start Changes for US731 - Nested Roster */
DECLARE @columnType as varchar(100)
DECLARE @default sysname, @sql nvarchar(max) 

SELECT  @columnType = DATA_TYPE  FROM INFORMATION_SCHEMA.COLUMNS WHERE   TABLE_NAME = 'Response' AND   COLUMN_NAME = 'RpsMatrix'


IF ( @columnType = 'int' )
BEGIN
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Response]') AND name = N'PK_Response')
		ALTER TABLE [dbo].[Response] DROP CONSTRAINT [PK_Response]

	SELECT @default = name FROM sys.default_constraints  
	WHERE parent_object_id = object_id('Response') AND type = 'D' 
		AND parent_column_id = (SELECT column_id FROM sys.columns WHERE object_id = object_id('Response') and name = 'RpsMatrix') 

	IF not @default is null
	BEGIN
		set @sql = N'alter table Response drop constraint ' + @default 
		exec sp_executesql @sql 
	END

	-- Change type of Response.RpsMatrix for Nested Roster
	ALTER TABLE [dbo].[Response] ALTER COLUMN [RpsMatrix] bigint NOT NULL

	-- Recreate default for RpsMatrix using a hard coded name
	ALTER TABLE [dbo].[Response] ADD CONSTRAINT DF__Response__RpsMatrix DEFAULT ((1)) FOR [RpsMatrix]

	--recreate the Primary Key
	ALTER TABLE [dbo].[Response] ADD  CONSTRAINT [PK_Response] PRIMARY KEY CLUSTERED 
	(
		[RpsRespondent] ASC,
		[RpsQuestion] ASC,
		[RpsMatrix] ASC,
		[RpsMention] ASC,
		[RpsType] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]


	-- Change type of ResponseModifLog.Matrix for Nested Roster
	ALTER TABLE [dbo].[ResponseModifLog] ALTER COLUMN [Matrix] bigint NOT NULL

	-- Change type of Note.NotMatrix for Nested Roster
	ALTER TABLE [dbo].[Note] ALTER COLUMN [NotMatrix] bigint NULL

END




IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondentresponse]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondentresponse]
GO

CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
	@ProjectId     INT,
	@UserId        INT,
	@CollectMode   INT,
	@RpsRespondent VARCHAR(10),
	@RpsQuestion   VARCHAR(10),
	@RpsMatrix     BIGINT,
	@RpsMention    INT,
	@RpsContent    NVARCHAR(100),
	@rpsOpened     NTEXT,
	@rpsType       INT
AS
  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = Getutcdate(),
         RpsContent = @RpsContent,
         RpsOpened = @RpsOpened
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  
  IF @@ROWCOUNT = 0
  BEGIN
    INSERT INTO Response
			 (RpsRespondent,
			  ProjectId,
			  CollectMode,
			  modifiedby,
			  modified,
			  RpsQuestion,
			  RpsMatrix,
			  RpsMention,
			  RpsContent,
			  RpsOpened,
			  RpsType)
	VALUES    (@RpsRespondent,
			  @ProjectId,
			  @CollectMode,
			  @UserId,
			  Getutcdate(),
			  @RpsQuestion,
			  @RpsMatrix,
			  @RpsMention,
			  @RpsContent,
			  @rpsOpened,
			  @rpsType)
  END
GO

IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondentresponsecode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondentresponsecode]
GO

CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponseCode]
	@ProjectId     INT,
	@UserId        INT,
	@CollectMode   INT,
	@RpsRespondent VARCHAR(10),
	@RpsQuestion   VARCHAR(10),
	@RpsMatrix     BIGINT,
	@RpsMention    INT,
	@RpsContent    NVARCHAR(100),
	@rpsType       INT
AS
  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN collectmode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = Getutcdate(),
         RpsContent = @RpsContent
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  
  IF @@ROWCOUNT = 0
  BEGIN
	INSERT INTO Response
			 (RpsRespondent,
			  ProjectId,
			  CollectMode,
			  modifiedby,
			  modified,
			  RpsQuestion,
			  RpsMatrix,
			  RpsMention,
			  RpsContent,
			  RpsOpened,
			  RpsType)
	VALUES    (@RpsRespondent,
			  @ProjectId,
			  @CollectMode,
			  @UserId,
			  Getutcdate(),
			  @RpsQuestion,
			  @RpsMatrix,
			  @RpsMention,
			  @RpsContent,
			  '',
			  @rpsType)
  END
GO


IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondentnote]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondentnote]
GO

/****** Object:  StoredProcedure [dbo].[Sp_updaterespondentnote]    Script Date: 05/11/2012 08:44:21 ******/
CREATE PROCEDURE [dbo].[Sp_updaterespondentnote]
                @projectId     INT,
                @UserId        INT,
                @collectMode   INT,
                @NotRespondent VARCHAR(10),
                @NotDateTime   DATETIME,
                @NotInterv     VARCHAR(10),
                @NotQuestion   VARCHAR(10),
                @NotMatrix     BIGINT,
                @NotNote       NVARCHAR(500)
AS
  UPDATE note
  SET    projectid = @ProjectId,
         collectmode = @CollectMode,
         modifiedby = @UserId,
         modified = Getutcdate(),
         notquestion = @NotQuestion,
         notmatrix = @NotMatrix,
         notnote = @NotNote
  WHERE  notrespondent = @NotRespondent
         AND notdatetime = @NotDateTime
         AND notinterv = @NotInterv
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO note
                 (projectid,
                  collectmode,
                  modifiedby,
                  modified,
                  notrespondent,
                  notdatetime,
                  notinterv,
                  notquestion,
                  notmatrix,
                  notnote)
      VALUES     (@ProjectId,
                  @CollectMode,
                  @UserId,
                  Getutcdate(),
                  @NotRespondent,
                  @NotDateTime,
                  @NotInterv,
                  @NotQuestion,
                  @NotMatrix,
                  @NotNote)
    END
    
GO

/* End Changes for US731 - Nested Roster */
